<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class NlpSemanticParsingLocalHotelType extends \Google\Model
{
  /**
   * @var bool
   */
  public $allInclusiveResort;
  /**
   * @var bool
   */
  public $beachResort;
  /**
   * @var bool
   */
  public $bedAndBreakfast;
  /**
   * @var bool
   */
  public $boutiqueHotel;
  /**
   * @var bool
   */
  public $businessHotel;
  /**
   * @var bool
   */
  public $cabin;
  /**
   * @var bool
   */
  public $campsite;
  /**
   * @var bool
   */
  public $capsuleHotel;
  /**
   * @var bool
   */
  public $casinoAccommodation;
  /**
   * @var bool
   */
  public $castleHotel;
  /**
   * @var bool
   */
  public $chalet;
  /**
   * @var bool
   */
  public $commonLodgingHouse;
  /**
   * @var bool
   */
  public $condoHotel;
  /**
   * @var bool
   */
  public $conventionHotel;
  /**
   * @var bool
   */
  public $cottage;
  /**
   * @var bool
   */
  public $ecoHotel;
  /**
   * @var bool
   */
  public $extendedStayHotel;
  /**
   * @var bool
   */
  public $farmstay;
  /**
   * @var bool
   */
  public $gite;
  /**
   * @var bool
   */
  public $golfResort;
  /**
   * @var bool
   */
  public $guestRanch;
  /**
   * @var bool
   */
  public $guesthouse;
  /**
   * @var bool
   */
  public $hostel;
  /**
   * @var bool
   */
  public $hotel;
  /**
   * @var bool
   */
  public $houseboat;
  /**
   * @var bool
   */
  public $inn;
  /**
   * @var bool
   */
  public $japaneseInn;
  /**
   * @var bool
   */
  public $japaneseInnWithHotSpring;
  /**
   * @var bool
   */
  public $lodge;
  /**
   * @var bool
   */
  public $lodging;
  /**
   * @var bool
   */
  public $loveHotel;
  /**
   * @var bool
   */
  public $motel;
  /**
   * @var bool
   */
  public $mountainHut;
  /**
   * @var bool
   */
  public $other;
  /**
   * @var bool
   */
  public $pension;
  /**
   * @var bool
   */
  public $resort;
  /**
   * @var bool
   */
  public $safariLodge;
  /**
   * @var bool
   */
  public $seasideResort;
  /**
   * @var bool
   */
  public $servicedApartment;
  /**
   * @var bool
   */
  public $skiResort;
  /**
   * @var bool
   */
  public $suite;
  /**
   * @var bool
   */
  public $vacationApartment;
  /**
   * @var bool
   */
  public $vacationHouse;
  /**
   * @var bool
   */
  public $vacationRental;
  /**
   * @var bool
   */
  public $villa;
  /**
   * @var bool
   */
  public $wellnessAndSpaAccommodation;
  /**
   * @var bool
   */
  public $youthHostel;

  /**
   * @param bool
   */
  public function setAllInclusiveResort($allInclusiveResort)
  {
    $this->allInclusiveResort = $allInclusiveResort;
  }
  /**
   * @return bool
   */
  public function getAllInclusiveResort()
  {
    return $this->allInclusiveResort;
  }
  /**
   * @param bool
   */
  public function setBeachResort($beachResort)
  {
    $this->beachResort = $beachResort;
  }
  /**
   * @return bool
   */
  public function getBeachResort()
  {
    return $this->beachResort;
  }
  /**
   * @param bool
   */
  public function setBedAndBreakfast($bedAndBreakfast)
  {
    $this->bedAndBreakfast = $bedAndBreakfast;
  }
  /**
   * @return bool
   */
  public function getBedAndBreakfast()
  {
    return $this->bedAndBreakfast;
  }
  /**
   * @param bool
   */
  public function setBoutiqueHotel($boutiqueHotel)
  {
    $this->boutiqueHotel = $boutiqueHotel;
  }
  /**
   * @return bool
   */
  public function getBoutiqueHotel()
  {
    return $this->boutiqueHotel;
  }
  /**
   * @param bool
   */
  public function setBusinessHotel($businessHotel)
  {
    $this->businessHotel = $businessHotel;
  }
  /**
   * @return bool
   */
  public function getBusinessHotel()
  {
    return $this->businessHotel;
  }
  /**
   * @param bool
   */
  public function setCabin($cabin)
  {
    $this->cabin = $cabin;
  }
  /**
   * @return bool
   */
  public function getCabin()
  {
    return $this->cabin;
  }
  /**
   * @param bool
   */
  public function setCampsite($campsite)
  {
    $this->campsite = $campsite;
  }
  /**
   * @return bool
   */
  public function getCampsite()
  {
    return $this->campsite;
  }
  /**
   * @param bool
   */
  public function setCapsuleHotel($capsuleHotel)
  {
    $this->capsuleHotel = $capsuleHotel;
  }
  /**
   * @return bool
   */
  public function getCapsuleHotel()
  {
    return $this->capsuleHotel;
  }
  /**
   * @param bool
   */
  public function setCasinoAccommodation($casinoAccommodation)
  {
    $this->casinoAccommodation = $casinoAccommodation;
  }
  /**
   * @return bool
   */
  public function getCasinoAccommodation()
  {
    return $this->casinoAccommodation;
  }
  /**
   * @param bool
   */
  public function setCastleHotel($castleHotel)
  {
    $this->castleHotel = $castleHotel;
  }
  /**
   * @return bool
   */
  public function getCastleHotel()
  {
    return $this->castleHotel;
  }
  /**
   * @param bool
   */
  public function setChalet($chalet)
  {
    $this->chalet = $chalet;
  }
  /**
   * @return bool
   */
  public function getChalet()
  {
    return $this->chalet;
  }
  /**
   * @param bool
   */
  public function setCommonLodgingHouse($commonLodgingHouse)
  {
    $this->commonLodgingHouse = $commonLodgingHouse;
  }
  /**
   * @return bool
   */
  public function getCommonLodgingHouse()
  {
    return $this->commonLodgingHouse;
  }
  /**
   * @param bool
   */
  public function setCondoHotel($condoHotel)
  {
    $this->condoHotel = $condoHotel;
  }
  /**
   * @return bool
   */
  public function getCondoHotel()
  {
    return $this->condoHotel;
  }
  /**
   * @param bool
   */
  public function setConventionHotel($conventionHotel)
  {
    $this->conventionHotel = $conventionHotel;
  }
  /**
   * @return bool
   */
  public function getConventionHotel()
  {
    return $this->conventionHotel;
  }
  /**
   * @param bool
   */
  public function setCottage($cottage)
  {
    $this->cottage = $cottage;
  }
  /**
   * @return bool
   */
  public function getCottage()
  {
    return $this->cottage;
  }
  /**
   * @param bool
   */
  public function setEcoHotel($ecoHotel)
  {
    $this->ecoHotel = $ecoHotel;
  }
  /**
   * @return bool
   */
  public function getEcoHotel()
  {
    return $this->ecoHotel;
  }
  /**
   * @param bool
   */
  public function setExtendedStayHotel($extendedStayHotel)
  {
    $this->extendedStayHotel = $extendedStayHotel;
  }
  /**
   * @return bool
   */
  public function getExtendedStayHotel()
  {
    return $this->extendedStayHotel;
  }
  /**
   * @param bool
   */
  public function setFarmstay($farmstay)
  {
    $this->farmstay = $farmstay;
  }
  /**
   * @return bool
   */
  public function getFarmstay()
  {
    return $this->farmstay;
  }
  /**
   * @param bool
   */
  public function setGite($gite)
  {
    $this->gite = $gite;
  }
  /**
   * @return bool
   */
  public function getGite()
  {
    return $this->gite;
  }
  /**
   * @param bool
   */
  public function setGolfResort($golfResort)
  {
    $this->golfResort = $golfResort;
  }
  /**
   * @return bool
   */
  public function getGolfResort()
  {
    return $this->golfResort;
  }
  /**
   * @param bool
   */
  public function setGuestRanch($guestRanch)
  {
    $this->guestRanch = $guestRanch;
  }
  /**
   * @return bool
   */
  public function getGuestRanch()
  {
    return $this->guestRanch;
  }
  /**
   * @param bool
   */
  public function setGuesthouse($guesthouse)
  {
    $this->guesthouse = $guesthouse;
  }
  /**
   * @return bool
   */
  public function getGuesthouse()
  {
    return $this->guesthouse;
  }
  /**
   * @param bool
   */
  public function setHostel($hostel)
  {
    $this->hostel = $hostel;
  }
  /**
   * @return bool
   */
  public function getHostel()
  {
    return $this->hostel;
  }
  /**
   * @param bool
   */
  public function setHotel($hotel)
  {
    $this->hotel = $hotel;
  }
  /**
   * @return bool
   */
  public function getHotel()
  {
    return $this->hotel;
  }
  /**
   * @param bool
   */
  public function setHouseboat($houseboat)
  {
    $this->houseboat = $houseboat;
  }
  /**
   * @return bool
   */
  public function getHouseboat()
  {
    return $this->houseboat;
  }
  /**
   * @param bool
   */
  public function setInn($inn)
  {
    $this->inn = $inn;
  }
  /**
   * @return bool
   */
  public function getInn()
  {
    return $this->inn;
  }
  /**
   * @param bool
   */
  public function setJapaneseInn($japaneseInn)
  {
    $this->japaneseInn = $japaneseInn;
  }
  /**
   * @return bool
   */
  public function getJapaneseInn()
  {
    return $this->japaneseInn;
  }
  /**
   * @param bool
   */
  public function setJapaneseInnWithHotSpring($japaneseInnWithHotSpring)
  {
    $this->japaneseInnWithHotSpring = $japaneseInnWithHotSpring;
  }
  /**
   * @return bool
   */
  public function getJapaneseInnWithHotSpring()
  {
    return $this->japaneseInnWithHotSpring;
  }
  /**
   * @param bool
   */
  public function setLodge($lodge)
  {
    $this->lodge = $lodge;
  }
  /**
   * @return bool
   */
  public function getLodge()
  {
    return $this->lodge;
  }
  /**
   * @param bool
   */
  public function setLodging($lodging)
  {
    $this->lodging = $lodging;
  }
  /**
   * @return bool
   */
  public function getLodging()
  {
    return $this->lodging;
  }
  /**
   * @param bool
   */
  public function setLoveHotel($loveHotel)
  {
    $this->loveHotel = $loveHotel;
  }
  /**
   * @return bool
   */
  public function getLoveHotel()
  {
    return $this->loveHotel;
  }
  /**
   * @param bool
   */
  public function setMotel($motel)
  {
    $this->motel = $motel;
  }
  /**
   * @return bool
   */
  public function getMotel()
  {
    return $this->motel;
  }
  /**
   * @param bool
   */
  public function setMountainHut($mountainHut)
  {
    $this->mountainHut = $mountainHut;
  }
  /**
   * @return bool
   */
  public function getMountainHut()
  {
    return $this->mountainHut;
  }
  /**
   * @param bool
   */
  public function setOther($other)
  {
    $this->other = $other;
  }
  /**
   * @return bool
   */
  public function getOther()
  {
    return $this->other;
  }
  /**
   * @param bool
   */
  public function setPension($pension)
  {
    $this->pension = $pension;
  }
  /**
   * @return bool
   */
  public function getPension()
  {
    return $this->pension;
  }
  /**
   * @param bool
   */
  public function setResort($resort)
  {
    $this->resort = $resort;
  }
  /**
   * @return bool
   */
  public function getResort()
  {
    return $this->resort;
  }
  /**
   * @param bool
   */
  public function setSafariLodge($safariLodge)
  {
    $this->safariLodge = $safariLodge;
  }
  /**
   * @return bool
   */
  public function getSafariLodge()
  {
    return $this->safariLodge;
  }
  /**
   * @param bool
   */
  public function setSeasideResort($seasideResort)
  {
    $this->seasideResort = $seasideResort;
  }
  /**
   * @return bool
   */
  public function getSeasideResort()
  {
    return $this->seasideResort;
  }
  /**
   * @param bool
   */
  public function setServicedApartment($servicedApartment)
  {
    $this->servicedApartment = $servicedApartment;
  }
  /**
   * @return bool
   */
  public function getServicedApartment()
  {
    return $this->servicedApartment;
  }
  /**
   * @param bool
   */
  public function setSkiResort($skiResort)
  {
    $this->skiResort = $skiResort;
  }
  /**
   * @return bool
   */
  public function getSkiResort()
  {
    return $this->skiResort;
  }
  /**
   * @param bool
   */
  public function setSuite($suite)
  {
    $this->suite = $suite;
  }
  /**
   * @return bool
   */
  public function getSuite()
  {
    return $this->suite;
  }
  /**
   * @param bool
   */
  public function setVacationApartment($vacationApartment)
  {
    $this->vacationApartment = $vacationApartment;
  }
  /**
   * @return bool
   */
  public function getVacationApartment()
  {
    return $this->vacationApartment;
  }
  /**
   * @param bool
   */
  public function setVacationHouse($vacationHouse)
  {
    $this->vacationHouse = $vacationHouse;
  }
  /**
   * @return bool
   */
  public function getVacationHouse()
  {
    return $this->vacationHouse;
  }
  /**
   * @param bool
   */
  public function setVacationRental($vacationRental)
  {
    $this->vacationRental = $vacationRental;
  }
  /**
   * @return bool
   */
  public function getVacationRental()
  {
    return $this->vacationRental;
  }
  /**
   * @param bool
   */
  public function setVilla($villa)
  {
    $this->villa = $villa;
  }
  /**
   * @return bool
   */
  public function getVilla()
  {
    return $this->villa;
  }
  /**
   * @param bool
   */
  public function setWellnessAndSpaAccommodation($wellnessAndSpaAccommodation)
  {
    $this->wellnessAndSpaAccommodation = $wellnessAndSpaAccommodation;
  }
  /**
   * @return bool
   */
  public function getWellnessAndSpaAccommodation()
  {
    return $this->wellnessAndSpaAccommodation;
  }
  /**
   * @param bool
   */
  public function setYouthHostel($youthHostel)
  {
    $this->youthHostel = $youthHostel;
  }
  /**
   * @return bool
   */
  public function getYouthHostel()
  {
    return $this->youthHostel;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NlpSemanticParsingLocalHotelType::class, 'Google_Service_Contentwarehouse_NlpSemanticParsingLocalHotelType');
